/* ════════════════════════════════════════════════════════════════
   BOUTON RETOUR EN HAUT DE PAGE AVEC DÉFILEMENT FLUIDE
════════════════════════════════════════════════════════════════ */

document.addEventListener("DOMContentLoaded", () => {  // Attend que le DOM soit chargé

    const boutonRetour = document.querySelector('.bouton-retour'); // Sélectionne le bouton
    let lastScroll = 0; // Stocke la position de scroll précédente

    // ── AFFICHAGE DU BOUTON EN FONCTION DU SCROLL ──
    window.addEventListener('scroll', () => { // Écoute le défilement
        const currentScroll = window.scrollY; // Position actuelle du scroll
        const maxScroll = document.documentElement.scrollHeight - window.innerHeight; // Hauteur max

        const isAtBottom = currentScroll >= maxScroll - 10; // Si en bas de page
        const isGoingUp = currentScroll < lastScroll; // Si on remonte
        const isAtTop = currentScroll <= 10; // Si en haut de page

        // ➤ Le bouton est visible si : en bas OU si on remonte (et pas en haut)
        if (isAtBottom || (isGoingUp && !isAtTop)) {
            boutonRetour.classList.add('visible'); // Affiche le bouton
        }
        // ➤ Sinon, il est invisible
        else {
            boutonRetour.classList.remove('visible'); // Cache le bouton
        }

        lastScroll = currentScroll; // Met à jour la dernière position
    });

    // ── CLIC SUR LE BOUTON : REMONTÉE FLUIDE ──
    boutonRetour.addEventListener('click', (e) => {
        e.preventDefault(); // Empêche le comportement par défaut
        window.scrollTo({
            top: 0,           // Position cible : en haut de page
            behavior: 'smooth' // Animation fluide
        });
    });

});
